/*
 
 Copyright (c) 2004 PXI Project Team
 
 Permission is hereby granted, free of charge, to any person obtaining a copy of
 this software and associated documentation files (the "Software"), to deal in the
 Software without restriction, including without limitation the rights to use,
 copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
 Software, and to permit persons to whom the Software is furnished to do so,
 subject to the following conditions:
 
 The above copyright notice and this permission notice shall be included in all copies
 or substantial portions of the Software.
 
 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 
 */

//  PXIButton.h
//  PXIView
//
//  last changed by: creysoft

/* Declaration of PXIButton
	This holds all the instance variables and methods for the PXIButton class.
	All the documentation should be here, but it's not.
*/

#import <Cocoa/Cocoa.h>
#import "PXIFileFormat.h"
#import "PXIMasterController.h"

@interface PXIButtonView : NSView {
	int partStyle;
	int textAlign;
	int textSize;
	int titleWidth;
	
	BOOL visible;
	BOOL enabled;
	BOOL hilite;
	BOOL autoHilite;
	BOOL showName;
	
	NSString * partName;
	NSString * fontName;
	
	NSTrackingRectTag myTrackingTag;
	BOOL oldAcceptsMouseMovedEvents;
	NSResponder * oldNextResponder;
	
	NSImage * defcorners;
	NSImage * stdcorners;
	NSImage * rndcorners;
	NSImage * hl_defcorners;
	NSImage * hl_stdcorners;
	NSImage * hl_rndcorners;
	NSImage * checkon;
	NSImage * checkoff;
	NSImage * checkclick;
	NSImage * radioon;
	NSImage * radiooff;
	NSImage * radioclick;
	NSImage * whitegraypat;
	NSImage * popuparrow;
	
}

- (BOOL)autoHilite;
- (void)setAutoHilite:(BOOL)newAutohilite;
- (NSString *)fontName;
- (void)setFontName:(NSString *)newFontname;
- (int)titleWidth;
- (void)setTitleWidth:(int)newTitlewidth;
- (NSString *)partName;
- (void)setPartName:(NSString *)newPartname;
- (int)partStyle;
- (void)setPartStyle:(int)newPartstyle;
- (BOOL)visible;
- (void)setVisible:(BOOL)newVisible;
- (BOOL)enabled;
- (void)setEnabled:(BOOL)newEnabled;
- (BOOL)hilite;
- (void)setHilite:(BOOL)newHilite;
- (BOOL)showName;
- (void)setShowName:(BOOL)newShowname;
- (int)textAlign;
- (void)setTextAlign:(int)newTextalign;
- (int)textSize;
- (void)setTextSize:(int)newTextsize;

@end
